#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fork Fork Mande pmarnason 118Mod01.fsh    by    pmarnason   
//https://www.shadertoy.com/view/43VfDt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


const vec3 u_baseColor       = vec3(10.0, 10.6, 1.0);
const vec3 u_colorExp        = vec3(1.0, 1.5, 3.0);
const float u_colorMul       = 1.0;
const float u_dMinFactor     = 1.0;
const float u_dMaxFactor     = 1.0;

const vec3 u_fogColor        = vec3(0.0, 0.0, 0.0);
const float u_highlightBlend = 0.4;

const float u_vignetteFactor = 10.0;
const float u_vignetteExp    = 1.0/60.0;

const vec3 u_evenTint = vec3(10.1, 1.0, 0.4);
const vec3 u_oddTint  = vec3(1.8, 1.0, 1.0);

// ───── New parameter for pattern scaling ─────
const float u_patternScale = 4200.0; // Adjust this to change the grid scale

//─────────────────────────────
// Fast sine/cosine approximations
//─────────────────────────────
float fastSin(float x) {
  const float PI = 3.14159265;
  x = mod(x + PI, 6.283185307) - PI;
  float B = 4.0 / PI;
  float C = -4.0 / (PI * PI);
  float y = B * x + C * x * abs(x);
  float P = 0.225;
  return P * (y * abs(y) - y) + y;
}
float fastCos(float x) {
  return fastSin(x + 1.57079633);
}

//─────────────────────────────
// Main image function
//─────────────────────────────
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 col = vec3(0.0);
    const int AA = 2;
    
    // Precompute time‐based values
    float it8 = iTime / 100.0;
    float it2 = iTime / 50.0;
    float it3 = iTime / 3.0;
    float it7 = iTime / 7.0;
    float ttm = fastCos(fastSin(it8)) * 6.2831;
    mat2 rotTtm = mat2(fastCos(ttm), fastSin(ttm), -fastSin(ttm), fastCos(ttm));
    vec2 trans = vec2(fastCos(it2) / 2.0, fastSin(it3) / 5.0);
    float zm = 200.0 + fastSin(it7) * 50.0;
    
    vec2 halfRes = iResolution.xy * 0.5;
    float invResY = 1.0 / iResolution.y;
    
    for (int j = 0; j < AA; j++){
      for (int i = 0; i < AA; i++){
          vec2 offset = vec2(float(i), float(j)) / float(AA);
          vec2 p = (fragCoord + offset - halfRes) * invResY;
          p = rotTtm * p - trans;
          vec2 cc = vec2(-0.57735 + 0.004, 0.57735) + p / zm;
          
          // Mandelbrot iteration (with derivative)
          vec2 z = vec2(0.0), dz = vec2(0.0);
          const int iter = 128;
          int ik = iter;
          for (int k = 0; k < iter; k++){
              float zx = z.x, zy = z.y;
              float newZx = zx * zx - zy * zy + cc.x;
              float newZy = 2.0 * zx * zy + cc.y;
              z = vec2(newZx, newZy);
              float dzx = dz.x, dzy = dz.y;
              dz = vec2(2.0 * (zx * dzx - zy * dzy) + 1.0,
                        2.0 * (zx * dzy + zy * dzx));
              if(zx * zx + zy * zy > 200.0){ ik = k; break; }
          }
          
          float lenZ = length(z);
          float ln = step(0.0, lenZ / 15.5 - 1.0);
          float lenDz = length(dz);
          float d = sqrt(1.0 / max(lenDz, 0.0001)) * log(dot(z, z));
          d = clamp(d * 50.0, 0.0, 1.0);
          
          // Determine alternating layer (parity)
          float dir = ( (ik % 2) == 0 ) ? -1.0 : 1.0;
          float sh = float(iter - ik) / float(iter);
          
          // ───── Repeating grid pattern ─────
          vec2 tuv = z / u_patternScale; // use the new parameter
          float tm = -ttm * sh * sh * 16.0;
          mat2 rotTm = mat2(fastCos(tm), fastSin(tm), -fastSin(tm), fastCos(tm));
          tuv = rotTm * tuv;
          tuv = abs(mod(tuv, 1.0/8.0) - 1.0/16.0);
          float invLenDz = 1.0 / max(lenDz, 0.0001);
          float pat = smoothstep(0.0, invLenDz, length(tuv) - 1.0/32.0);
          pat = min(pat, smoothstep(0.0, invLenDz, abs(max(tuv.x, tuv.y) - 1.0/16.0) - (0.04/16.0)));
          
          // ───── Compute the base color ─────
          float maxVal = max(1.0 - pat, 1.0 - ln);
          float factor = min(d * u_dMinFactor, u_dMaxFactor);
          vec3 colComputed = pow(min(u_baseColor * factor, vec3(1.0)),
                                 u_colorExp) * u_colorMul;
          vec3 baseCol = (sqrt(colComputed) * 0.5 + 0.7)
                         * mix(vec3(1.0), vec3(maxVal), 0.5);
          
          // ───── Apply alternating tint ─────
          vec3 altCol = (dir < 0.0) ? baseCol * u_evenTint : baseCol * u_oddTint;
          vec3 lCol = altCol;
          
          // ───── Add white highlights (pseudo-reflection) ─────
          vec3 rd = normalize(vec3(p, 1.0));
          rd = reflect(rd, vec3(0.0, 0.0, -1.0));
          float diff = clamp(dot(z*0.5 + 0.5, rd.xy), 0.0, 1.0) * d;
          lCol += mix(lCol, vec3(1.0)*ln, u_highlightBlend)
                  * diff * diff * 0.5 * (pat * 0.6 + 0.6);
          
          if (mod(float(ik), 6.0) < 0.5)
             lCol = lCol.yxz;
          lCol = mix(lCol.xzy, lCol, d / 1.2);
          lCol = mix(u_fogColor, lCol, sh * d);
          
          col += min(lCol, vec3(1.0));
      }
    }
    col /= float(AA * AA);
    
    // Apply a subtle vignette:
    vec2 uv = fragCoord / iResolution.xy;
    col *= pow(u_vignetteFactor * (1.0 - uv.x) * (1.0 - uv.y) * uv.x * uv.y,
               u_vignetteExp) * u_colorMul;
    
    fragColor = vec4(sqrt(max(col, vec3(0.0))), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

